SET TERM ^ ;



CREATE OR ALTER TRIGGER PROCESSOS_MI_RELACIONA_PROCESSO FOR PROCESSOS_MINERAR
ACTIVE AFTER INSERT OR UPDATE POSITION 20
AS
DECLARE VARIABLE COD_DADOS DOM_CODIGO;
DECLARE VARIABLE STR_PROCESSO_NEW VARCHAR(50);
DECLARE VARIABLE STR_PROCESSO VARCHAR(25);
DECLARE VARIABLE STR_SEQ_RECURSO VARCHAR(5);
DECLARE VARIABLE INT_SEQ_RECURSO INTEGER;
BEGIN
  /* Trigger text */
  -- IF ((NEW.PROCESSO IS DISTINCT FROM OLD.PROCESSO) AND
  IF ((NEW.COD_DADOS IS NULL) AND
      (NEW.PROCESSO IS NOT NULL)) THEN
  BEGIN
    STR_PROCESSO_NEW = TRIM(NEW.PROCESSO);
    IF ((:STR_PROCESSO_NEW <> '') AND
        (NEW.CODIGO IS NOT NULL)) THEN
    BEGIN
      IF (CHAR_LENGTH(:STR_PROCESSO_NEW) = 25) THEN
      BEGIN
        SELECT FIRST 1 DADOS.CODIGO
        FROM DADOS
        WHERE DADOS.PROCESSO_CNJ = :STR_PROCESSO_NEW AND
              DADOS.SEQ_RECURSO IS NULL
        INTO :COD_DADOS;

        IF (:COD_DADOS IS NOT NULL) THEN
        BEGIN
          UPDATE PROCESSOS_MINERAR
          SET PROCESSOS_MINERAR.COD_DADOS = :COD_DADOS
          WHERE PROCESSOS_MINERAR.CODIGO = NEW.CODIGO;
        END
      END
      ELSE
      IF (CHAR_LENGTH(:STR_PROCESSO_NEW) = 31) THEN
      BEGIN
        STR_PROCESSO = SUBSTRING(:STR_PROCESSO_NEW FROM 1 FOR 25);
        STR_SEQ_RECURSO = SUBSTRING(:STR_PROCESSO_NEW FROM 27 FOR 5);
        INT_SEQ_RECURSO = CAST(:STR_SEQ_RECURSO AS INTEGER);

        SELECT FIRST 1 DADOS.CODIGO
        FROM DADOS
        WHERE DADOS.PROCESSO_CNJ = :STR_PROCESSO AND
              DADOS.SEQ_RECURSO = :INT_SEQ_RECURSO
        INTO :COD_DADOS;

        IF (:COD_DADOS IS NOT NULL) THEN
        BEGIN
          UPDATE PROCESSOS_MINERAR
          SET PROCESSOS_MINERAR.COD_DADOS = :COD_DADOS
          WHERE PROCESSOS_MINERAR.CODIGO = NEW.CODIGO;
        END
      END
    END
  END
END
^
SET TERM ; ^